% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentist.R
\name{grimshaw_gp_mle}
\alias{grimshaw_gp_mle}
\title{Maximum likelihood estimation of generalised Pareto parameters}
\usage{
grimshaw_gp_mle(x)
}
\arguments{
\item{x}{A numeric vector containing only \strong{positive} values, assumed
to be a random sample from a generalized Pareto distribution.}
}
\value{
A numeric vector of length 2.  The estimates of the \strong{negated}
  shape parameter \eqn{k (= -\xi)} and the scale parameter
  \eqn{a (= \sigma)}.
}
\description{
Uses the methodology of Grimshaw (1993) to find the MLEs of the parameters
of the generalised Pareto distribution, based on a sample of positive
values.  The function is essentially the same as that made available with
Grimshaw (1993), with only minor modifications.
}
\examples{
u <- quantile(gom, probs = 0.65)
grimshaw_gp_mle((gom - u)[gom > u])
}
\references{
Grimshaw, S. D. (1993) Computing Maximum Likelihood Estimates
  for the Generalized Pareto Distribution.  Technometrics, 35(2), 185-191.
  and Computing (1991) 1, 129-133.
  \url{https://doi.org/10.1080/00401706.1993.10485040}.
}
\seealso{
\code{\link{gp}} for details of the parameterisation of the GP
  distribution, in terms of \eqn{\sigma} and \eqn{\xi}.
}
