% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{dec_neg}
\alias{dec_neg}
\title{Number of individuals for which the decision is negative.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
dec_neg
}
\description{
\code{dec_neg} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the decision is negative (i.e., cases not called or not predicted).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{dec_neg} individuals depends on the population size \code{\link{N}} and
the decision's proportion of negative decisions \code{(1 - \link{ppod})} and is split further into two subsets of
\code{\link{cr}} by the negative predictive value \code{\link{NPV}} and
\code{\link{mi}} by the false omission rate \code{\link{FOR} = 1 - \link{NPV}}.

Perspectives:

\enumerate{
  \item by condition:

  The frequency \code{\link{dec_neg}} is determined by the population size \code{\link{N}} times
  the proportion of negative decisions \code{(1 - \link{ppod})}:

  \code{\link{dec_neg}  =  \link{N} x (1 - \link{ppod})}

  \item by decision:

  a. The frequency \code{\link{cr}} is determined by \code{\link{dec_neg}} times the negative predictive value \code{\link{NPV}}:

  \code{\link{cr}  =  \link{dec_neg} x \link{NPV}}


  b. The frequency \code{\link{mi}} is determined by \code{\link{dec_neg}} times the false omission rate \code{\link{FOR} = (1 - \link{NPV})}:

  \code{\link{mi}  =  \link{dec_neg} x \link{FOR}  =  \link{dec_neg} x (1 - \link{NPV})}

}

  \item to other frequencies:
  In a population of size \code{\link{N}} the following relationships hold:

  \itemize{

    \item \code{\link{N}  =  \link{cond_true} + \link{cond_false}} (by condition)

    \item \code{\link{N}  =  \link{dec_pos} + \link{dec_neg}} (by decision)

    \item \code{\link{N} = \link{dec_cor} + \link{dec_err}} (by correspondence of decision to condition)

    \item \code{\link{N}  =  \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }
}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
dec_neg <- 1000 * .67   # => sets dec_neg to 67\% of 1000 = 670 cases.
is_freq(dec_neg)        # => TRUE
is_prob(dec_neg)        # => FALSE, as dec_neg is no probability (but ppod, NPV and FOR are)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: 
\code{\link{N}},
\code{\link{cond_false}},
\code{\link{cond_true}},
\code{\link{cr}},
\code{\link{dec_cor}},
\code{\link{dec_err}},
\code{\link{dec_pos}},
\code{\link{fa}},
\code{\link{hi}},
\code{\link{mi}}
}
\concept{frequencies}
\keyword{datasets}
