% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternaryDiag.R
\name{ternaryDiag}
\alias{ternaryDiag}
\title{Ternary diagram}
\usage{
ternaryDiag(
  x,
  name = colnames(x),
  text = NULL,
  grid = TRUE,
  gridCol = grey(0.6),
  mcex = 1.2,
  line = "none",
  robust = TRUE,
  group = NULL,
  tol = 0.975,
  ...
)
}
\arguments{
\item{x}{matrix or data.frame with 3 columns}

\item{name}{names of the variables}

\item{text}{default NULL, text for each point can be provided}

\item{grid}{if TRUE a grid is plotted additionally in the ternary diagram}

\item{gridCol}{color for the grid lines}

\item{mcex}{label size}

\item{line}{may be set to \dQuote{none}, \dQuote{pca}, \dQuote{regression},
\dQuote{regressionconf}, \dQuote{regressionpred}, \dQuote{ellipse},
\dQuote{lda}}

\item{robust}{if line equals TRUE, it dedicates if a robust estimation is
applied or not.}

\item{group}{if line equals \dQuote{da}, it determines the grouping variable}

\item{tol}{if line equals \dQuote{ellipse}, it determines the parameter for
the tolerance ellipse}

\item{\dots}{further parameters, see, e.g., \code{par()}}
}
\description{
This plot shows the relative proportions of three variables (compositional
parts) in one diagramm. Before plotting, the data are scaled.
}
\details{
The relative proportions of each variable are plotted.
}
\examples{

data(arcticLake)
ternaryDiag(arcticLake)

data(coffee)
x <- coffee[,2:4]
grp <- as.integer(coffee[,1])
ternaryDiag(x, col=grp, pch=grp)
ternaryDiag(x, grid=FALSE, col=grp, pch=grp)
legend("topright", legend=unique(coffee[,4]), pch=1:2, col=1:2)

ternaryDiag(x, grid=FALSE, col=grp, pch=grp, line="ellipse", tol=c(0.975,0.9), lty=2)
ternaryDiag(x, grid=FALSE, line="pca")
ternaryDiag(x, grid=FALSE, col=grp, pch=grp, line="pca", lty=2, lwd=2)

}
\references{
Reimann, C., Filzmoser, P., Garrett, R.G., Dutter, R. (2008)
\emph{Statistical Data Analysis Explained. Applied Environmental Statistics with
R}. John Wiley and Sons, Chichester.
}
\seealso{
\code{\link[StatDA]{ternary}}
}
\author{
Peter Filzmoser <\email{P.Filzmoser@tuwien.ac.at}>, Matthias Templ
}
\keyword{aplot}
\keyword{multivariate}
