% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show-study-details.R
\name{get_study_details}
\alias{get_study_details}
\title{Retrieve details for a specific Rapid7 Open Data study}
\usage{
get_study_details(study_name, rapid7_opendata_api_key = rapid7_api_key())
}
\arguments{
\item{study_name}{A valid study name. This should be a value from the field
\code{uniqid} in the result from a call to \code{\link[=list_studies]{list_studies()}}. Current known,
good values are "\code{sonar.national_exposure}", "\code{heisenberg.cowrie}",
"\code{sonar.atg_10001_tcp}", "\code{sonar.http}", "\code{sonar.ssl}", "\code{sonar.tcp}",
"\code{sonar.moressl}", "\code{sonar.rdns_v2}", "\code{sonar.udp}", "\code{sonar.cio}",
"\code{sonar.https}", "\code{sonar.fdns}", "\code{sonar.rdns}",  and "\code{sonar.fdns_v2}".}

\item{rapid7_opendata_api_key}{Your Rapid7 Open Data API key. The various
API interface function look for this key in \code{RAPID7_OPENDATA_API_KEY}.
You can manually provide this key and if the function is used interactively
and the key is not found, you will be prompted to enter the key.}
}
\value{
data frame
}
\description{
Retrieve details for a specific Rapid7 Open Data study
}
\examples{
try(
  get_study_details("sonar.national_exposure"),
  silent=TRUE
) -> details
}
