% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iron_condour.R
\name{iron.condour}
\alias{iron.condour}
\title{Iron Condour Strategy Function}
\usage{
iron.condour(
  k_long_call,
  k_short_call,
  k_long_put,
  k_short_put,
  c1,
  c2,
  p1,
  p2,
  llimit = 20,
  ulimit = 20
)
}
\arguments{
\item{k_long_call}{Excercise Price of Long call Option}

\item{k_short_call}{Excercise Price of Short call Option}

\item{k_long_put}{Excercise Price of Long Put Option}

\item{k_short_put}{Excercise Price of Short Put Option}

\item{c1}{Premium of Long call Option}

\item{c2}{Premium of Short call Option}

\item{p1}{Premium of Long Put Option}

\item{p2}{Premium of Short Put Option}

\item{llimit}{Lower limit of stock price at Expiration., Default: 20}

\item{ulimit}{Upper Limit of Stock Price at Expiration, Default: 20}
}
\value{
OUTPUT_DESCRIPTION Returns the profit/loss generated from the strategy along with the profit/loss of individual contract and an interactive graph for the same.
}
\description{
This function can be used to develop a Iron Condour Strategy.
}
\details{
An Iron condor is an options strategy created with four options consisting of two puts (one long and one short) and two calls (one long and one short), and four strike prices, all with the same expiration date.
}
\examples{
iron.condour(100, 95, 105, 102, 2.3, 1.25, 3.2, 2.3)
}
