context("testthat roclet")

test_that("@tests captures tests", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
    #' @tests 
    #' expect_equal(2, 2)
    #'
    NULL")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 1)
  expect_equal(length(out$testexamples), 0)
  
  out <- out$tests[[1]]
  
  # # Generated by roxytest: Do not edit by hand!
  #
  # context("<text>")
  #  
  # test_that("[unknown alias] @ L5", {
  #  expect_equal(2, 2)
  # })
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'context("<text>")', fixed = TRUE)
  expect_match(out, "expect_equal(2, 2)", fixed = TRUE)
})

test_that("@testexamples captures tests", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
    #' @testexamples 
    #' expect_equal(2, 2)
    #'
    NULL")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 0)
  expect_equal(length(out$testexamples), 1)
  
  out <- out$testexamples[[1]]
  
  # # Generated by roxytest: Do not edit by hand!
  #
  # context("<text>")
  #  
  # test_that("[unknown alias] @ L5", {
  #  expect_equal(2, 2)
  # })
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'context("<text>")', fixed = TRUE)
  expect_match(out, "expect_equal(2, 2)", fixed = TRUE)
})

test_that("All good @tests", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
    #' Summing two numbers
    #'
    #' @param x A number
    #' @param y Another number
    #' 
    #' @tests 
    #' expect_equal(f(0, 0), 0)
    #' expect_equal(f(2, 3), 5)
    f <- function(x, y) {
      x + y
    }")
  
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 1)
  expect_equal(length(out$testexamples), 0)
  
  out <- out$tests[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'context("<text>")', fixed = TRUE)
  expect_match(out, 'test_that(\"Function f() @ L10\", {\n  expect_equal(f(0, 0), 0)\n  expect_equal(f(2, 3), 5)\n})', fixed = TRUE)
})

test_that("All good @testexamples", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
    #' Summing two numbers
    #'
    #' @examples 
    #' x <- 2
    #' 
    #' @testexamples
    #' expect_equal(x, 2)
    f <- function(x, y) {
      x + y
    }")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 0)
  expect_equal(length(out$testexamples), 1)
  
  out <- out$testexamples[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'context("<text>")', fixed = TRUE)
  expect_match(out, 'x <- 2', fixed = TRUE)
  expect_match(out, 'expect_equal(x, 2)', fixed = TRUE)
})

test_that("No @tests is ignored", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
    #' Summing two numbers
    #'
    #' @param x A number
    #' @param y Another number
    f <- function(x, y) {
      x + y
    }")
  expect_equal(out, list(tests = list(), testexamples = list()))
})



test_that("Multiple functions", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
                                 #' A function to do x
#' 
#' @param x A number
#' 
#' @tests 
#' expect_equal(foo(2), sqrt(2))
#' expect_error(foo(\"a string\"))
#' 
#' @return something
foo <- function(x) {
  return(sqrt(x))
}

#' A function to do y
#' 
#' @param x Character vector
#' @param y Character vector
#' 
#' @tests 
#' expect_equal(bar(\"A\", \"B\"), paste(\"A\", \"B\", sep = \"/\"))
#' 
#' @export
bar <- function(x, y) {
  paste0(x, \"/\", y)
}

#' A function with missing parameter docs
#' 
#' @param x Character vector
#' 
#' @export
foobar <- function(x, y) {
  paste0(x, \"/\", y)
}
")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 1)
  expect_equal(length(out$testexamples), 0)
  out <- out$tests[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'Function foo() @', fixed = TRUE)
  expect_match(out, 'Function bar() @', fixed = TRUE)
  expect_false(grepl('Function foobar() @', out, fixed = TRUE))
})



# https://github.com/mikldk/roxytest/issues/12
test_that("Remove content in \\donttest{} and \\dontrun{}", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
    #' Summing two numbers
    #'
    #' @examples 
    #' x <- 2
    #' \\donttest{
    #' a <- 3
    #' }
    #' \\dontrun{
    #' b <- runinf(1e6)
    #' hist(b)
    #' }
    #' 
    #' @testexamples
    #' expect_equal(x, 2)
    f <- function(x, y) {
      x + y
    }")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 0)
  expect_equal(length(out$testexamples), 1)
  
  out <- out$testexamples[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'context("<text>")', fixed = TRUE)
  expect_match(out, 'x <- 2', fixed = TRUE)
  expect_match(out, 'expect_equal(x, 2)', fixed = TRUE)
  
  expect_false(grepl('donttest', out, fixed = TRUE))
  expect_false(grepl('dontrun', out, fixed = TRUE))
  
  expect_match(out, 'a <-', fixed = TRUE)
  
  expect_false(grepl('b <-', out, fixed = TRUE))
  expect_false(grepl('hist(b)', out, fixed = TRUE))
})

test_that("Remove content in \\donttest{} and \\dontrun{} - with if's...", {
  out <- roxygen2::roc_proc_text(testthat_roclet(), "
    #' Summing two numbers
    #'
    #' @examples
    #' x <- 2
    #' \\donttest{
    #' a <- 2
    #' if (TRUE) {
    #'   b <- 2
    #' }
    #' }
    #' \\dontrun{
    #' v <- 2
    #' if (TRUE) {
    #'    w <- 2
    #' }
    #' }
    #' \\dontshow{
    #' q <- 2
    #' if (TRUE) {
    #'    r <- 2
    #' }
    #' }
    #'
    #' @testexamples
    #' expect_equal(x, 2)
    f <- function(x, y) {
      x + y
    }")
  expect_equal(length(out), 2)
  expect_equal(length(out$tests), 0)
  expect_equal(length(out$testexamples), 1)

  out <- out$testexamples[[1]]
  
  expect_match(out, "^# Generated by roxytest: Do not edit by hand!")
  expect_match(out, 'context("<text>")', fixed = TRUE)
  expect_match(out, 'x <- 2', fixed = TRUE)
  expect_match(out, 'expect_equal(x, 2)', fixed = TRUE)

  expect_false(grepl('dontrun', out, fixed = TRUE))
  expect_false(grepl('donttest', out, fixed = TRUE))
  expect_false(grepl('dontshow', out, fixed = TRUE))
  
  # donttest
  expect_match(out, 'a <- 2', fixed = TRUE)
  expect_match(out, 'b <- 2', fixed = TRUE)
  
  # dontrun
  expect_false(grepl('v <-', out, fixed = TRUE))
  expect_false(grepl('w <-', out, fixed = TRUE))
  
  # dontshow
  expect_match(out, 'q <- 2', fixed = TRUE)
  expect_match(out, 'r <- 2', fixed = TRUE)
})
