% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsu.R
\name{modify_graph_hsu}
\alias{modify_graph_hsu}
\title{Hsu et al. (2009) Algorithm}
\usage{
modify_graph_hsu(g, f, cores = 1L)
}
\arguments{
\item{g}{The digraph to be transformed, written as a data frame where each row represents a 
directed arc. The columns must be named \code{from} and \code{to}, and can be of any data
type. On each row no cells can be \code{NULL} or \code{NA}.}

\item{f}{The set of forbidden paths, written as a data frame. Each row represents a path
as a sequence of nodes. Each row may be of different size, filling the empty cells with
\code{NA}. All nodes involved must be part of \code{g}, and no forbidden path can be of
size 2. This is because the latter is thought as an arc that should not exist in
the first place.}

\item{cores}{This algorithm can be run using R's parallel processing functions. This
variable represents the number of processing cores you want to assign for the
transformation. The default value is one single core. 
It is suggested to not assign all of your available cores to the function.}
}
\value{
A new graph, generated following Hsu's backward construction, in which no path
   includes one of the forbidden subpaths. The graph is returned in a data frame format,
   where each row represents a directed arc, with or without additional attributes (if
   corresponds). However, regardless of the data type of the original graph, nodes on the
   new graph are of type character. The new nodes names are generated by incrementally
   concatenating the nodes on a forbidden path, but split by a pipe character (\code{|}).
}
\description{
It is an implementation of Hsu et al. algorithm to transform a digraph and a 
   known set of forbidden paths, into a new graph that does not allow any forbidden path 
   as part of its solutions.
}
\details{
This version of the algorithm produce smaller graphs, with less new nodes and arcs.
}
\examples{
# Obtain a graph and its forbidden subpaths
graph <- data.frame(from = c("c", "c", "u", "u", "t", "a", "a", "r", "e", "e", "e", 
                             "p", "i", "i", "n", "o"),
                    to = c("u", "p", "e", "t", "a", "r", "i", "u", "r", "i", "p", 
                           "n", "n", "o", "o", "m"),
                    stringsAsFactors = FALSE)
fpaths <- data.frame(X1 = c("u", "p", "a", "a"), X2 = c("t", "n", "i", "r"), 
                     X3 = c("a", "o", "n", "u"), X4 = c("r", "m", "o", NA),  
                     X5 = c("u", NA, NA, NA), stringsAsFactors = FALSE)

# Show the input
graph
fpaths

# Call the function and store the result
gStar <- modify_graph_hsu(graph, fpaths)
gStar

}
\seealso{
\url{https://doi.org/10.1007/978-3-642-03095-6_60}

Other Graph Transformation: \code{\link{modify_graph_vd}}
}
\concept{Graph Transformation}
