% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignoreDependencies.R
\name{ignoreDependencies}
\alias{ignoreDependencies}
\alias{ignoreDependencies,character-method}
\alias{ignoreDependencies,Scenario-method}
\alias{ignoreDependencies<-}
\alias{ignoreDependencies<-,character-method}
\alias{ignoreDependencies<-,Scenario-method}
\title{Ignore dependencies for a Scenario}
\usage{
ignoreDependencies(ssimObject)

\S4method{ignoreDependencies}{character}(ssimObject)

\S4method{ignoreDependencies}{Scenario}(ssimObject)

ignoreDependencies(ssimObject) <- value

\S4method{ignoreDependencies}{character}(ssimObject) <- value

\S4method{ignoreDependencies}{Scenario}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{Scenario}} object}

\item{value}{character string of Datafeed names to be ignored, separated by
commas (optional)}
}
\value{
A character string: Scenario Datafeeds that will be ignored.
}
\description{
Retrieves or sets the Datafeeds to ignore for a \code{\link{Scenario}}.
}
\examples{
\donttest{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# List the Datafeeds to ignore
ignoreDependencies(myScenario)

# Set Scenario Datafeeds to ignore
ignoreDependencies(myScenario) <- "stsim_RunControl,stsim_TransitionTarget"
}

}
