% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{VarStaticCutSplit-class}
\alias{VarStaticCutSplit-class}
\alias{make_static_cut_split}
\alias{CumulativeCutSplit-class}
\alias{VarDynCutSplit-class}
\alias{VarDynCutSplit}
\title{Splits for cutting by values of a numeric variable}
\usage{
make_static_cut_split(
  var,
  split_label,
  cuts,
  cutlabels = NULL,
  cfun = NULL,
  cformat = NULL,
  split_format = NULL,
  split_name = var,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  indent_mod = 0L,
  cindent_mod = 0L,
  cvar = "",
  cextra_args = list(),
  label_pos = "visible",
  cumulative = FALSE,
  page_prefix = NA_character_
)

VarDynCutSplit(
  var,
  split_label,
  cutfun,
  cutlabelfun = function(x) NULL,
  cfun = NULL,
  cformat = NULL,
  split_format = NULL,
  split_name = var,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  cumulative = FALSE,
  indent_mod = 0L,
  cindent_mod = 0L,
  cvar = "",
  cextra_args = list(),
  label_pos = "visible",
  page_prefix = NA_character_
)
}
\arguments{
\item{var}{string, variable name}

\item{split_label}{string. Label string to be associated with the table generated by the split. Not to be confused with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{cuts}{numeric. Cuts to use}

\item{cutlabels}{character (or NULL). Labels for the cuts}

\item{cfun}{list/function/NULL. tabulation function(s) for creating content rows. Must accept \code{x} or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional arguments accepted by analysis functions. See \code{\link{analyze}}.}

\item{cformat}{format spec. Format for content rows}

\item{split_format}{FormatSpec. Default format associated with the split being created.}

\item{split_name}{string. Name associiated with this split (for pathing, etc)}

\item{child_labels}{string. One of \code{"default"}, \code{"visible"}, \code{"hidden"}. What should the display behavior be for the  labels (ie label rows) of the children of this split. Defaults to \code{"default"} which flags the label row as visible only if the child has 0 content rows.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation function. Element position in thte list corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do not match a formal argument of the ttabulation function.}

\item{indent_mod}{numeric. Modifier for the default indent position for the structure created by this function(subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which corresponds to the unmodified default behavior.}

\item{cindent_mod}{numeric(1). The indent modifier for the content tables generated by this split.}

\item{cvar}{character(1). The variable, if any, which the content function should accept. Defaults to NA.}

\item{cextra_args}{list. Extra arguments to be passed to the content function when tabulating row group summaries.}

\item{label_pos}{character(1). Location the variable label should be displayed, Accepts  hidden (default for non-analyze row splits), visible, topleft, and - for analyze splits only - default.  For analyze calls, \code{default} indicates that the variable
should be visible if and only if multiple variables are analyzed at the same level of nesting.}

\item{cumulative}{logical. Should the cuts be treated as cumulative. Defaults to \code{FALSE}}

\item{page_prefix}{character(1). Prefix, to be appended with the split value, when forcing pagination between the children of this split/table}

\item{cutfun}{function. Function which accepts the \emph{full vector} of \code{var} values and returns cut points to be used (via \code{cut}) when splitting data during tabulation}

\item{cutlabelfun}{function. Function which returns either labels for the cuts or NULL when passed the return value of \code{cutfun}}
}
\value{
a \code{VarStaticCutSplit}, \code{CumulativeCutSplit} object for \code{make_static_cut_split},
or a \code{VarDynCutSplit} object for \code{VarDynCutSplit()}
}
\description{
Splits for cutting by values of a numeric variable

Create static cut or static cumulative cut split
}
