% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funs.R
\name{remove_split_levels}
\alias{remove_split_levels}
\alias{keep_split_levels}
\alias{drop_split_levels}
\alias{drop_and_remove_levels}
\alias{reorder_split_levels}
\alias{trim_levels_in_group}
\title{Split functions}
\usage{
remove_split_levels(excl)

keep_split_levels(only, reorder = TRUE)

drop_split_levels(df, spl, vals = NULL, labels = NULL, trim = FALSE)

drop_and_remove_levels(excl)

reorder_split_levels(neworder, newlabels = neworder, drlevels = TRUE)

trim_levels_in_group(innervar, drop_outlevs = TRUE)
}
\arguments{
\item{excl}{character. Levels to be excluded (they will not be reflected in the resulting table structure regardless
of presence in the data).}

\item{only}{character. Levels to retain (all others will be dropped).}

\item{reorder}{logical(1). Should the order of \code{only} be used as the order of the children of the split. defaults to \code{TRUE}}

\item{df}{dataset (data.frame or tibble)}

\item{spl}{A Split object defining a partitioning or analysis/tabulation of the data.}

\item{vals}{ANY. For internal use only.}

\item{labels}{character. Labels to use for the remaining levels instead of the existing ones.}

\item{trim}{logical(1). Should splits corresponding with 0 observations be kept when tabulating.}

\item{neworder}{character. New order or factor levels.}

\item{newlabels}{character. Labels for (new order of) factor levels}

\item{drlevels}{logical(1). Should levels in the data which do not appear in \code{neworder} be dropped. Defaults to \code{TRUE}}

\item{innervar}{character(1). Variable whose factor levels should be trimmed (e.g., empty levels dropped) \emph{separately within each grouping defined at this point in the structure}}

\item{drop_outlevs}{logical(1). Should empty levels in the variable being split on (ie the 'outer' variable, not \code{innervar})
be dropped? Defaults to \code{TRUE}}
}
\value{
a closure suitable for use as a splitting function (\code{splfun}) when creating a table layout
}
\description{
Split functions
}
\section{Custom Splitting Function Details}{


User-defined custom split functions can perform any type of computation
on the incoming data provided that they meed the contract for generating
'splits' of the incoming data 'based on' the split object.

Split functions are functions that accept:
\describe{
\item{df}{data.frame of incoming data to be split}
\item{spl}{a Split object. this is largely an internal detail custom functions will not need to worry about,
but  \code{obj_name(spl)}, for example, will give the name of the split as it will appear in paths in the resulting table}
\item{vals}{Any pre-calculated values. If given non-null values, the values returned should match these. Should be NULL in most cases and can likely be ignored}
\item{labels}{Any pre-calculated value labels. Same as above for \code{values}}
\item{trim}{If \code{TRUE}, resulting splits that are empty should be removed}
\item{(Optional) .spl_context}{a data.frame describing previously performed splits which collectively arrived at \code{df}}
}

The function must then output a \code{named list} with the following elements:

\describe{
\item{values}{The vector of all values corresponding to the splits of \code{df}}
\item{datasplit}{a list of data.frames representing the groupings of the actual observations from \code{df}.}
\item{labels}{a character vector giving a string label for each value listed in the \code{values} element above}
\item{(Optional) extras}{If present, extra arguments to be passed to summary and analysis functions
whenever they are executed on the corresponding element of \code{datasplit} or a subset thereof}
}

One way to generate custom splitting functions is to wrap existing split functions and modify either
the incoming data before they are called, or their outputs.
}

\examples{
l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("COUNTRY", split_fun = remove_split_levels(c("USA", "CAN", "CHE", "BRA"))) \%>\%
  analyze("AGE")

build_table(l, DM)

l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("COUNTRY", split_fun = keep_split_levels(c("USA", "CAN", "BRA"))) \%>\%
  analyze("AGE")

build_table(l, DM)
l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX", split_fun = drop_split_levels) \%>\%
  analyze("AGE")

build_table(l, DM)
l <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX", split_fun = drop_and_remove_levels(c("M", "U"))) \%>\%
  analyze("AGE")

build_table(l, DM)
}
