% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpa.R
\name{inspectProfiles}
\alias{inspectProfiles}
\title{Provides information to help decide how many profiles to use for subsequent rties analyses.}
\usage{
inspectProfiles(
  whichModel,
  prepData,
  paramEst,
  n_profiles,
  dist0name = NULL,
  dist1name = NULL,
  plot_obs_name = NULL,
  minMax = NULL,
  time_length = NULL,
  numPlots = NULL,
  seed = NULL
)
}
\arguments{
\item{whichModel}{The name of the model that is being investigated (e.g., "inertCoord" or "clo")}

\item{prepData}{A dataframe that was produced with the "dataPrep" function.}

\item{paramEst}{A dataframe created by either indivInertCoord or indivClo containing the parameter estimates for each dyad.}

\item{n_profiles}{The number of latent profiles.}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable (e.g., "Women"). Default is dist0.}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable (e.g., "Men"). Default is dist1}

\item{plot_obs_name}{An optional name for the observed state variable to appear on plots (e.g., "Emotional Experience").}

\item{minMax}{An optional vector with desired minimum and maximum quantiles to be used for setting the y-axis range on the plots, e.g., minMax <- c(.1, .9) would set the y-axis limits to the 10th and 90th percentiles of the observed state variables. If not provided, the default is to use the minimum and maximum observed values of the state variables.}

\item{time_length}{An optional value specifying how many time points to plot across. Default is the 75th percentile for the time variable.}

\item{numPlots}{Only relevant for the inertCoord model. An optional value controlling how many random examples of each profile are produced. Default is 3.}

\item{seed}{Only relevant for the inertCoord model. An optional integer argument that sets the seed of R's random number generator to create reproducible trajectories. If used, the "numPlots" can be set to one - otherwise each plot is replicated 3 times.}
}
\value{
A dataframe called "profileData" that contains the profile classification for each dyad.
}
\description{
The function prints out the number of dyads in each profile for a specified number of profiles. It also prints out: 1) a figure showing the best clustering solution as indicated by BIC (e.g., the observed data separated into clusters, produced by mclust), 2) a line plot showing the content of the best solution (e.g., the mean parameter estimates for each profile) and 3) prototypical model-predicted trajectories for each profile. For the inertia-coordination model, it produces sets of prototypical examples by using the inertia-coordination parameters to predict temporal trajectories, with random noise added at each temporal step. This process is required because the inertia-coordination model only represents local dynamics and predictions bear no resemblance to observed variables without the addition of noise. An optional argument, "seed" sets the seed for the random number generator, so you can get the same plots each time. If the "seed" argument is used, then only one plot per profile is produced. For the coupled-oscillator, this step is not necessary and one prototypical trajectory is plotted for each profile.
}
\examples{
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", 
 obs_name="dial", dist_name="female", time_name="time")
taus <-c(2,3)
embeds <- c(3,4)
delta <- 1
derivs <- estDerivs(prepData=newData, taus=taus, embeds=embeds, delta=delta, idConvention=500)
clo <- indivClo(derivData=derivs$data, whichModel="coupled")
profiles <- inspectProfiles(whichModel="clo", prepData=newData, paramEst=clo$params, n_profiles=2)
head(profiles)

}
