% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_responses.R
\name{get_responses}
\alias{get_responses}
\title{Download questionnaire results}
\usage{
get_responses(
  form_id,
  api = NULL,
  page_size = 25,
  since = NULL,
  until = NULL,
  after = NULL,
  before = NULL,
  completed = NULL,
  query = NULL,
  fields = NULL
)
}
\arguments{
\item{form_id}{The form id of the typeform you want the results for.}

\item{api}{Default \code{NULL}. Your private api key. If \code{api} is \code{NULL},
the environment variable \code{Sys.getenv("typeform_api2")} is used.}

\item{page_size}{Maximum number of responses.
Default value is 25. Maximum value is 1000.}

\item{since}{default \code{NULL}. Fetch only the results after a specific date and
time. If \code{NULL} return all results. This should be a date time object.
The timezone of the object will be converted to UTC.}

\item{until}{default \code{NULL}. Similar to \code{since}.}

\item{after}{default \code{NULL}. Fetch only the results after a specific date and
time. If \code{NULL} return all results. If you use the after parameter, the responses
will be sorted in the order that our system processed them
(instead of the default order, submitted_at).
This ensures that you can traverse the complete set of responses without repeating entries.}

\item{before}{default \code{NULL}. Similar to \code{after}}

\item{completed}{default \code{NULL}, return all results.
Fetch only completed results (\code{TRUE}), or only not-completed results
(=\code{FALSE}). If \code{NULL} return all results. Warning. It's not
possible to determine completed/non-completed results.}

\item{query}{Limit request to only responses that that include the specified term.}

\item{fields}{Not implemented. Pull requests welcome}
}
\value{
A list. The first value is meta information. Subsequent elements are
questions..
}
\description{
Download results for a particular typeform questionnaire.
}
\seealso{
https://developer.typeform.com/responses/reference/retrieve-responses/
}
