% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.all.params.R
\name{makeplot.all.params}
\alias{makeplot.all.params}
\title{Plotting all parameters}
\usage{
makeplot.all.params(chains, burnin = 0, facet = TRUE, free_y = FALSE,
  strip = 1)
}
\arguments{
\item{chains}{A set of rwty.chain objects}

\item{burnin}{The number of trees to omit as burnin.}

\item{facet}{Boolean denoting whether to make a facet plot.}

\item{free_y}{TRUE/FALSE to turn free y scales on the facetted plots on or off (default FALSE). Only works if facet = TRUE.}

\item{strip}{Number indicating which column to strip off (i.e., strip=1 removes first column, which is necessary for most MCMC outputs in which the first column is just the generation).
You can skip multiple columns by passing a vector of columns to skip, e.g., strip=c(1,4,6).}
}
\value{
param.plot Returns a list of ggplot objects.
}
\description{
Plots all parameter values, including tree topologies (see makeplot.topology) over the length of the MCMC chain
}
\examples{
\dontrun{
data(fungus)
makeplot.all.params(fungus, burnin=20)
}
}
\keyword{convergence,}
\keyword{mcmc,}
\keyword{parameter,}
\keyword{phylogenetics}
\keyword{plot,}
