% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{add_sanity_check}
\alias{add_sanity_check}
\title{Adds a sanity check to the list of already performed sanity checks}
\usage{
add_sanity_check(
  fail_vec,
  description = "-",
  counter_meas = "-",
  data,
  data_name = checkmate::vname(x = data),
  example_size = 3,
  param_name = "-",
  call = h_deparsed_sys_call(which = -3),
  fail_callback
)
}
\arguments{
\item{fail_vec}{logical vector where \code{TRUE} indicates that a
fail has happend}

\item{description}{(optional) of the sanity check. default is "-".}

\item{counter_meas}{(optional) description of the counter measures that
were applied to correct the problems. default is "-".}

\item{data}{(optional) where the fails were found. Is used to
store examples of failures. default is "-".}

\item{data_name}{(optional) name of the data set that was used. defaults is
the name of the object passed to data.}

\item{example_size}{(optional) number failures to be extracted from the
object passed to \code{data}. By default 3 random examples are extracted.}

\item{param_name}{(optional) name of the parameter(s) that is used. This may
be helpful for filtering the table of all performed sanity checks.}

\item{call}{(optional) by default tracks the function that called
\link{add_sanity_check}.}

\item{fail_callback}{(optional) user-defined function that is called if
any element of \code{fail_vec} is \code{TRUE}. This is helpful if an
additional warning or error should be thrown or maybe a log-entry
should be created.}
}
\value{
a list with three elements
  \describe{
    \item{entry_sanity_table}{invisibly the sanity check that is stored
    internally with the other sanity checks}
    \item{fail_vec}{\code{fail_vec} as passed over to this function}
    \item{fail}{TRUE if any element of fail is TRUE. Otherwise FALSE.}
  }
  All performed sanity checks can be fetched via \link{get_sanity_checks}
}
\description{
Adds a sanity check to the list of already performed sanity checks
}
\examples{
d <- data.frame(person_id = 1:4, bmi = c(18,23,-1,35), age = 31:34)
dummy_call <- function(x) {
  add_sanity_check(
    x$bmi < 15,
    description = "bmi above 15",
    counter_meas = "none",
    data = x,
    param_name = "bmi")
  add_sanity_check(
    x$bmi > 30,
    description = "bmi below 30",
    counter_meas = "none")
}
dummy_call(x = d)
get_sanity_checks()
add_sanity_check(
   d$bmi < 15,
   description = "bmi above 15",
   fail_callback = warning)
}
