% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sankeywheel.R
\name{sankeywheel}
\alias{sankeywheel}
\title{Create Dependency Wheels and Sankey Diagrams}
\usage{
sankeywheel(from, to, weight, type = "dependencywheel", width = NULL,
  height = NULL, seriesName = "demo series", theme = "sandsignika",
  title = "Example Chart", titleAlign = "center", titleSize = "20px",
  titleColor = "#333333", subtitle = "", subtitleAlign = "center",
  subtitleSize = "", subtitleColor = "#666666", elementId = NULL,
  ...)
}
\arguments{
\item{from}{from verctor;}

\item{to}{to vector;}

\item{weight}{weight vector;}

\item{type}{Charts type, dependencywheel or sankey;}

\item{width}{chart width, for example, "100\%";}

\item{height}{chart height, for example, "400px";}

\item{seriesName}{Series name, like "demo series";}

\item{theme}{chart theme, you can use these themes:
darkgreen/darkblue/avocado/darkunica/gray/
gridlight/grid/sandsignika/sunset;}

\item{title}{title;}

\item{titleAlign}{title alignment, left/center/right;}

\item{titleSize}{title size, like "20px";}

\item{titleColor}{title color, like "#333333";}

\item{subtitle}{subtitle;}

\item{subtitleAlign}{subtitle alignment, left/center/right;}

\item{subtitleSize}{subtitle size, like "16px";}

\item{subtitleColor}{subtitle color, like "#666666";}

\item{elementId}{NULL.}

\item{...}{Additional parameters.}
}
\description{
@description By binding R functions and the 'Highcharts' \url{http://www.highcharts.com/} charting library, 'sankeywheel' package provides a simple way to draw dependency wheels and sankey diagrams.
}
\examples{
library(sankeywheel)
if(interactive()){
    sankeywheel(from = sankeydf$from,
        to = sankeydf$to,
        weight = sankeydf$weight,
        type = "dependencywheel")
    sankeywheel(from = sankeydf$from,
        to = sankeydf$to,
        weight = sankeydf$weight,
        type = "sankey",
        theme = "sunset")
}

}
