% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sasfunclust_name.R
\docType{package}
\name{sasfunclust-package}
\alias{sasfunclust}
\alias{sasfunclust-package}
\title{Sparse and smooth functional data clustering}
\description{
Implements the sparse and smooth functional clustering (SaS-Funclust) method (Centofanti et al. (2021) <arXiv:2103.15224>) that aims to classify a sample of curves into homogeneous groups while jointly detecting the most informative portions of domain.
}
\details{
\tabular{ll}{
Package: \tab sasfunclust\cr
Type: \tab Package\cr
Version: \tab 1.0.0 \cr
Date: \tab  2021-04-01 \cr
License: \tab GPL-3\cr
}
}
\examples{
\dontrun{

n_i=20
train<-simulate_data("Scenario I",n_i=n_i,sd = 1,sd2_basis = 0.5^2)
lambda_s_seq=10^seq(-4,-3)
lambda_l_seq=10^seq(-1,0)
G_seq=2
mod_cv<-sasfclust_cv(X=train$X,grid=train$grid,G_seq=G_seq,
lambda_l_seq = lambda_l_seq,lambda_s_seq =lambda_s_seq,maxit = 5,K_fold = 2,q=10)
plot(mod_cv)

mod<-sasfclust(X=train$X,grid=train$grid,G_seq=mod_cv$G_opt,
lambda_l = mod_cv$lambda_l_opt,lambda_s_seq =mod_cv$lambda_s_opt,maxit = 5,q=10)

print(aa$clus$classes)
plot(mod)
}
}
\references{
Centofanti, F., Lepore, A., & Palumbo, B. (2021).
Sparse and Smooth Functional Data Clustering.
\emph{arXiv preprint arXiv:2103.15224}.
}
\seealso{
\code{\link{sasfclust}},  \code{\link{sasfclust_cv}}
}
\author{
Fabio Centofanti, Antonio Lepore, Biagio Palumbo
}
