% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.jury.stat.r
\name{as.jury.stat}
\alias{as.jury.stat}
\title{Calculates jury-level statistics}
\usage{
as.jury.stat(pg, n, seed = NULL, ndraw = 1e+05)
}
\arguments{
\item{pg}{The proportion of jurors who favor a guilty verdict.}

\item{n}{The size of the sample used to estimate pg.}

\item{seed}{Set seed for random number generation for replication, default is NULL (optional).}

\item{ndraw}{The number of simulations used to generate results. Should be very large number (default = 100000).}
}
\value{
Returns a list of jury-level statistics
}
\description{
Calculates jury-level statistics based on user-defined inputs.
}
\examples{
   as.jury.stat(pg=.50, n=500)

   as.jury.stat(pg=10/12, n=1200, seed=123, ndraw=10000)
}
