% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_sbo_dictionary.R
\name{as_sbo_dictionary}
\alias{as_sbo_dictionary}
\alias{as_sbo_dictionary.character}
\title{Coerce to dictionary}
\usage{
as_sbo_dictionary(x, ...)

\method{as_sbo_dictionary}{character}(x, .preprocess = identity, EOS = "", ...)
}
\arguments{
\item{x}{object to be coerced.}

\item{...}{further arguments passed to or from other methods.}

\item{.preprocess}{a function for corpus preprocessing.}

\item{EOS}{a length one character vector listing all (single character)
end-of-sentence tokens.}
}
\value{
A \code{sbo_dictionary} object.
}
\description{
Coerce objects to \code{sbo_dictionary} class.
}
\details{
This function is an S3 generic for coercing existing objects to
\code{sbo_dictionary} class objects. Currently, only a method for character
vectors is implemented, and this will be described below.

\emph{\strong{Character vector input}}:
Calling \code{as_sbo_dictionary(x)} simply decorates the character
vector \code{x} with the class \code{sbo_dictionary} attribute,
and with customizable \code{.preprocess} and \code{EOS} attributes.
}
\examples{
dict <- as_sbo_dictionary(c("a","b","c"), .preprocess = tolower, EOS = ".")
}
\author{
Valerio Gherardi
}
