% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_get_wfs.R
\name{item_get_wfs}
\alias{item_get_wfs}
\title{Download and load from SB WFS service (Deprecated)}
\usage{
item_get_wfs(sb_id, as_sf = FALSE, ..., session)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{as_sf}{boolean, return data in sf format}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\description{
This function attempts to download the spatial layer data attached to the
requested SB item. SB exposes discrete spatial objects (points, polygons) as 
web services based on the Open Geospatial Consortium, 
\href{https://www.ogc.org/standards/wfs}{Web Feature Service (WFS)}
standardized interface. This requires the following libraries not by default
installed with sbtools: \code{sf}, \code{httr}, and \code{xml2}. 
You can install them simply by running \code{install.packages(c("xml2", "httr", "sf"))}
}
