% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{nmi}
\alias{nmi}
\title{Normalized mutual information (NMI)}
\usage{
nmi(c1, c2, variant = c("max", "min", "sqrt", "sum", "joint"))
}
\arguments{
\item{c1}{a vector containing the labels of the first classification. Must be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{c2}{a vector containing the labels of the second classification.}

\item{variant}{a string in ("max", "min", "sqrt", "sum", "joint"): different variants of NMI. Default use "max".}
}
\value{
a scalar with the normalized mutual information .
}
\description{
A function to compute the NMI between two classifications
}
\examples{
 ## calculate Normalized Mutal Information score for two sets of labels
 data(sceiad_subset_data)
 nmi(sceiad_subset_data$CellType_predict, sceiad_subset_data$cluster)
}
