% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fn_cross_index}
\alias{fn_cross_index}
\title{Creates random index for k-fold cross validation}
\usage{
fn_cross_index(base, k)
}
\arguments{
\item{base}{input dataframe}

\item{k}{number of cross validation}
}
\value{
The function a list of length k, each holding an array of index/row number for sampling the base.
}
\description{
The function base and returns a list of length k, to be used for k-fold cross validation sampling. Each element of the returned list is an array of random index for sampling for k-fold cross validation.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
suppressWarnings(RNGversion('3.5.0'))
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
data$Y_pred <- sample(0:1,size=nrow(data),replace=TRUE)
data_k_list <- fn_cross_index(base = data,k = 5)
data_k_list$index1
data_k_list$index2
data_k_list$index3
data_k_list$index4
data_k_list$index5
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
