% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data_handling.R
\name{quantile_to_range_long}
\alias{quantile_to_range_long}
\title{Change Data from a Plain Quantile Format to a Long Range Format}
\usage{
quantile_to_range_long(data, keep_quantile_col = TRUE)
}
\arguments{
\item{data}{a data.frame following the specifications shown in the example
\code{\link{range_example_data_long}})}

\item{keep_quantile_col}{keep the quantile column in the final
output after transformation (default is FALSE)}
}
\value{
a data.frame in a long interval range format
}
\description{
Transform data from a format that uses quantiles only to one that uses
interval ranges to denote quantiles.

Given a data.frame that follows the structure shown in
\code{\link{quantile_example_data}}, the function outputs the same
data in a long format as (as shown in
\code{\link{range_example_data_long}}).
}
\examples{
quantile <- scoringutils::quantile_example_data

long <- scoringutils::quantile_to_range_long(quantile)

}
