% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undersample.R
\name{undersample_mindist}
\alias{undersample_mindist}
\title{Undersample a dataset by iteratively removing the observation with the lowest total distance to its neighbors of the same class.}
\usage{
undersample_mindist(data, cls, cls_col, m, dist_calc = "euclidean")
}
\arguments{
\item{data}{Dataset to undersample. Aside from \code{cls_col}, must be numeric.}

\item{cls}{Class to be undersampled.}

\item{cls_col}{Column containing class information.}

\item{m}{Desired number of observations after undersampling.}

\item{dist_calc}{Method for distance calculation. See \code{\link[stats]{dist}()}.}
}
\value{
An undersampled dataframe.
}
\description{
Undersample a dataset by iteratively removing the observation with the lowest total distance to its neighbors of the same class.
}
\examples{
setosa <- iris[iris$Species == "setosa", ]
nrow(setosa)
undersamp <- undersample_mindist(setosa, "setosa", "Species", 50)
nrow(undersamp)
}
