% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secure.R
\name{secure.control}
\alias{secure.control}
\title{Internal control function for secure}
\usage{
secure.control(mu = 1, nu = 1.1, MMerr = 0.001, MMiter = 100,
  outTol = 1e-06, outMaxIter = 200, inMaxIter = 200, inTol = 1e-04,
  lamMaxFac = 1, lamMinFac = 1e-10, gamma0 = 2, elnetAlpha = 0.95,
  spU = 0.25, spV = 0.25)
}
\arguments{
\item{mu}{penalty parameter used in enforcing orthogonality}

\item{nu}{penalty parameter used in enforcing orthogonality (incremental rate of mu)}

\item{MMerr}{tolerence in the majorization maximization(MM) algorithm for computing initial values when missing value occurs}

\item{MMiter}{maximum number iterations in the MM algorithm}

\item{outTol}{tolerence of convergence of outer loop in CURE}

\item{outMaxIter}{maximum number of outer loop iteration in CURE}

\item{inMaxIter}{maximum number of inner loop iteration in CURE}

\item{inTol}{tolerence value required for convergence of inner loop in CURE}

\item{lamMaxFac}{a multiplier of calculated lambda_max}

\item{lamMinFac}{a multiplier of determing lambda_min as a fraction of lambda_max}

\item{gamma0}{power parameter in the adaptive weights}

\item{elnetAlpha}{elastic net penalty parameter}

\item{spU}{maximum proportion of nonzero elements in each column of U}

\item{spV}{maximum proportion of nonzero elements in each column of V}
}
\value{
a list of controling parameter.
}
\description{
list of parameters for controling secure fitting
}

