% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwRDA.R
\name{pwRDA}
\alias{pwRDA}
\title{Piecewise redundancy analysis (pwRDA)}
\usage{
pwRDA(x.ord, y.ord, BPs, n.rand = 99)
}
\arguments{
\item{x.ord}{ordered explanatory matrix}

\item{y.ord}{ordered community matrix}

\item{BPs}{community breakpoints}

\item{n.rand}{The number of randomizations for significance computation}
}
\value{
Returns an invisible list of length 4:
 \enumerate{
  \item \code{..$summ}: summary statistics of the pwRDA analysis;
  \item \code{..$rda.0}: full model cca object, which is described separately in vegan::\code{\link[vegan]{cca.object}}
  \item \code{..$rda.pw}: pw model cca object, which is described separately in vegan::\code{\link[vegan]{cca.object}}
}
}
\description{
Perform a pwRDA using the specified breakpoints
}
\examples{
data(sim1)
sim1o<-OrdData(sim1$envi,sim1$comm)
\dontshow{
w50<-SMW(sim1o$yo, ws=50, n.rand=5)
sim1.pw<-pwRDA(sim1o$xo,sim1o$yo, BPs=bp(extract(w50)),n.rand=10)
}
\donttest{
w50<-SMW(sim1o$yo, ws=50)
sim1.pw<-pwRDA(sim1o$xo,sim1o$yo, BPs=bp(extract(w50)))
}
}
\author{
Danilo Candido Vieira
}
