% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.info}
\alias{sensibo.pod.info}
\title{Gets additional info of a specific air conditioner (pod) of the authenticated user.}
\usage{
sensibo.pod.info(pod, key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id.}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A list of the available details for the given pod or an empty list if the pod doesn't exist.
}
\description{
Gets additional info of a specific air conditioner (pod) of the authenticated user.
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Getting the details for the first pod
pod.details <- sensibo.pod.info(pods.id[1])

}
}
