% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R, R/tidyverse.R
\name{tidyverse}
\alias{tidyverse}
\alias{inner_join.sftime}
\alias{left_join.sftime}
\alias{right_join.sftime}
\alias{full_join.sftime}
\alias{semi_join.sftime}
\alias{anti_join.sftime}
\alias{filter.sftime}
\alias{arrange.sftime}
\alias{group_by.sftime}
\alias{ungroup.sftime}
\alias{rowwise.sftime}
\alias{mutate.sftime}
\alias{transmute.sftime}
\alias{select.sftime}
\alias{rename.sftime}
\alias{slice.sftime}
\alias{summarise.sftime}
\alias{summarize.sftime}
\alias{distinct.sftime}
\alias{gather.sftime}
\alias{pivot_longer.sftime}
\alias{spread.sftime}
\alias{sample_n.sftime}
\alias{sample_frac.sftime}
\alias{nest.sftime}
\alias{unnest.sftime}
\alias{separate.sftime}
\alias{unite.sftime}
\alias{separate_rows.sftime}
\title{'tidyverse' methods for \code{sftime} objects}
\usage{
inner_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

left_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

right_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

full_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

semi_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

anti_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

filter.sftime(.data, ..., .dots)

arrange.sftime(.data, ..., .dots)

group_by.sftime(.data, ..., add = FALSE)

ungroup.sftime(.data, ...)

rowwise.sftime(.data, ...)

mutate.sftime(.data, ..., .dots)

transmute.sftime(.data, ..., .dots)

select.sftime(.data, ...)

rename.sftime(.data, ...)

slice.sftime(.data, ..., .dots)

summarise.sftime(.data, ..., .dots, do_union = TRUE, is_coverage = FALSE)

summarize.sftime(.data, ..., .dots, do_union = TRUE, is_coverage = FALSE)

distinct.sftime(.data, ..., .keep_all = FALSE)

\method{gather}{sftime}(
  data,
  key,
  value,
  ...,
  na.rm = FALSE,
  convert = FALSE,
  factor_key = FALSE
)

\method{pivot_longer}{sftime}(
  data,
  cols,
  names_to = "name",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  names_ptypes = NULL,
  names_transform = NULL,
  names_repair = "check_unique",
  values_to = "value",
  values_drop_na = FALSE,
  values_ptypes = NULL,
  values_transform = NULL,
  ...
)

\method{spread}{sftime}(data, key, value, fill = NA, convert = FALSE, drop = TRUE, sep = NULL)

sample_n.sftime(
  tbl,
  size,
  replace = FALSE,
  weight = NULL,
  .env = parent.frame()
)

sample_frac.sftime(
  tbl,
  size = 1,
  replace = FALSE,
  weight = NULL,
  .env = parent.frame()
)

\method{nest}{sftime}(.data, ...)

\method{unnest}{sftime}(data, ..., .preserve = NULL)

\method{separate}{sftime}(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)

\method{unite}{sftime}(data, col, ..., sep = "_", remove = TRUE)

\method{separate_rows}{sftime}(data, ..., sep = "[^[:alnum:]]+", convert = FALSE)
}
\arguments{
\item{x}{An object of class \code{sftime}.}

\item{y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A character vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so that you
can check they're correct; suppress the message by supplying \code{by} explicitly.

To join by different variables on \code{x} and \code{y}, use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a vector with length > 1.
For example, \code{by = c("a", "b")} will match \code{x$a} to \code{y$a} and \code{x$b} to
\code{y$b}. Use a named vector to match different variables in \code{x} and \code{y}.
For example, \code{by = c("a" = "b", "c" = "d")} will match \code{x$a} to \code{y$b} and
\code{x$c} to \code{y$d}.

To perform a cross-join, generating all combinations of \code{x} and \code{y},
use \code{by = character()}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{...}{other arguments}

\item{.data}{An object of class \code{stime}.}

\item{.dots}{see corresponding function in package \code{dplyr}}

\item{add}{see corresponding function in dplyr}

\item{do_union}{logical; in case \code{summary} does not create a geometry column, should geometries be created by unioning using \link[sf]{st_union}, or simply by combining using \link[sf]{st_combine}? Using \link[sf]{st_union} resolves internal boundaries, but in case of unioning points, this will likely change the order of the points; see Details.}

\item{is_coverage}{logical; if \code{do_union} is \code{TRUE}, use an optimized algorithm for features that form a polygonal coverage (have no overlaps)}

\item{.keep_all}{see corresponding function in dplyr}

\item{data}{see original function docs}

\item{key}{see original function docs}

\item{value}{see original function docs}

\item{na.rm}{see original function docs}

\item{convert}{see \link[tidyr]{separate_rows}}

\item{factor_key}{see original function docs}

\item{cols}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to pivot into
longer format.}

\item{names_to}{A string specifying the name of the column to create
from the data stored in the column names of \code{data}.

Can be a character vector, creating multiple columns, if \code{names_sep}
or \code{names_pattern} is provided. In this case, there are two special
values you can take advantage of:
\itemize{
\item \code{NA} will discard that component of the name.
\item \code{.value} indicates that component of the name defines the name of the
column containing the cell values, overriding \code{values_to}.
}}

\item{names_prefix}{A regular expression used to remove matching text
from the start of each variable name.}

\item{names_sep}{If \code{names_to} contains multiple values,
these arguments control how the column name is broken up.

\code{names_sep} takes the same specification as \code{\link[tidyr:separate]{separate()}}, and can either
be a numeric vector (specifying positions to break on), or a single string
(specifying a regular expression to split on).

\code{names_pattern} takes the same specification as \code{\link[tidyr:extract]{extract()}}, a regular
expression containing matching groups (\verb{()}).

If these arguments do not give you enough control, use
\code{pivot_longer_spec()} to create a spec object and process manually as
needed.}

\item{names_pattern}{If \code{names_to} contains multiple values,
these arguments control how the column name is broken up.

\code{names_sep} takes the same specification as \code{\link[tidyr:separate]{separate()}}, and can either
be a numeric vector (specifying positions to break on), or a single string
(specifying a regular expression to split on).

\code{names_pattern} takes the same specification as \code{\link[tidyr:extract]{extract()}}, a regular
expression containing matching groups (\verb{()}).

If these arguments do not give you enough control, use
\code{pivot_longer_spec()} to create a spec object and process manually as
needed.}

\item{names_ptypes}{A list of column name-prototype pairs.
A prototype (or ptype for short) is a zero-length vector (like \code{integer()}
or \code{numeric()}) that defines the type, class, and attributes of a vector.
Use these arguments to confirm that the created columns are the types that
you expect.

If not specified, the type of the columns generated from \code{names_to} will
be character, and the type of the variables generated from \code{values_to}
will be the common type of the input columns used to generate them.}

\item{names_transform}{A list of column name-function pairs.
Use these arguments if you need to change the type of specific columns.
For example, \code{names_transform = list(week = as.integer)} would convert
a character week variable to an integer.}

\item{names_repair}{What happens if the output has invalid column names?
The default, \code{"check_unique"} is to error if the columns are duplicated.
Use \code{"minimal"} to allow duplicates in the output, or \code{"unique"} to
de-duplicated by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}
for more options.}

\item{values_to}{A string specifying the name of the column to create
from the data stored in cell values. If \code{names_to} is a character
containing the special \code{.value} sentinel, this value will be ignored,
and the name of the value column will be derived from part of the
existing column names.}

\item{values_drop_na}{If \code{TRUE}, will drop rows that contain only \code{NA}s
in the \code{value_to} column. This effectively converts explicit missing values
to implicit missing values, and should generally be used only when missing
values in \code{data} were created by its structure.}

\item{values_ptypes}{A list of column name-prototype pairs.
A prototype (or ptype for short) is a zero-length vector (like \code{integer()}
or \code{numeric()}) that defines the type, class, and attributes of a vector.
Use these arguments to confirm that the created columns are the types that
you expect.

If not specified, the type of the columns generated from \code{names_to} will
be character, and the type of the variables generated from \code{values_to}
will be the common type of the input columns used to generate them.}

\item{values_transform}{A list of column name-function pairs.
Use these arguments if you need to change the type of specific columns.
For example, \code{names_transform = list(week = as.integer)} would convert
a character week variable to an integer.}

\item{fill}{see original function docs}

\item{drop}{see original function docs}

\item{sep}{see \link[tidyr]{separate_rows}}

\item{tbl}{see original function docs}

\item{size}{see original function docs}

\item{replace}{see original function docs}

\item{weight}{see original function docs}

\item{.env}{see original function docs}

\item{.preserve}{see \link[tidyr:nest]{unnest}}

\item{col}{see \link[tidyr]{separate}}

\item{into}{see \link[tidyr]{separate}}

\item{remove}{see \link[tidyr]{separate}}

\item{extra}{see \link[tidyr]{separate}}
}
\value{
\itemize{
  \item For \code{_join} methods: An object of class \code{sftime} 
  representing the joining result of \code{x} and \code{y}. See 
  \code{\link[dplyr]{mutate-joins}}.
  \item For \code{filter}: See \code{\link[dplyr]{filter}}.
  \item For \code{arrange}: See \code{\link[dplyr]{arrange}}. 
  \item For \code{group_by} and \code{ungroup}: A grouped \code{sftime} 
  object. See \code{\link[dplyr]{arrange}}. 
  \item For \code{rowwise}: An \code{sftime} object. See 
  \code{\link[dplyr]{rowwise}}. 
  \item For \code{mutate} and \code{transmute}: See 
  \code{\link[dplyr]{mutate}}.
  \item For \code{select}: See \code{\link[dplyr]{select}}. If the active 
  time column is not explicitly selected, a \code{sf} object is returned. 
  \item For \code{rename}: See \code{\link[dplyr]{rename}}.    
  \item For \code{slice}: See \code{\link[dplyr]{slice}}.
  \item For \code{summarize} and \code{summarise}: See 
  \code{\link[dplyr]{summarise}}.  
  \item For \code{distinct}: See \code{\link[dplyr]{distinct}}.
  \item For \code{gather}: See \code{\link[tidyr]{gather}}. 
}
}
\description{
'tidyverse' methods for \code{sftime} objects. Geometries are sticky, use 
\code{\link{as.data.frame}} to let \code{dplyr}'s own methods drop them. Use 
these methods without the \code{.sftime} suffix and after loading the 
'tidyverse' package with the generic (or after loading package 'tidyverse').
}
\examples{
g1 <- st_sfc(st_point(1:2), st_point(c(5, 8)), st_point(c(2, 9)))
x1 <- st_sftime(a = 1:3, geometry = g1, time = Sys.time())

g2 <- st_sfc(st_point(c(4, 6)), st_point(c(4, 6)), st_point(c(4, 6)))
x2 <- st_sftime(a = 2:4, geometry = g2, time = Sys.time())

library(dplyr)

## inner_join
inner_join(x1, as.data.frame(x2), by = "a") # note: the active time column is
# time.x and the active geometry column geometry.x

inner_join(x2, as.data.frame(x1), by = "a")

## left_join
left_join(x1, as.data.frame(x2), by = "a")

left_join(x2, as.data.frame(x1), by = "a")

## right_join
right_join(x1, as.data.frame(x2), by = "a")

right_join(x2, as.data.frame(x1), by = "a")

## full_join
full_join(x1, as.data.frame(x2), by = "a")

full_join(x2, as.data.frame(x1), by = "a")

## semi_join
semi_join(x1, as.data.frame(x2), by = "a")

semi_join(x2, as.data.frame(x1), by = "a")

## anti_join
anti_join(x1, as.data.frame(x2), by = "a")

anti_join(x2, as.data.frame(x1), by = "a")

## filter
filter(x1, a <= 2)

## arrange
arrange(x1, dplyr::desc(a))

## group_by
group_by(x1, time)

## ungroup
ungroup(group_by(x1, time))

## rowwise
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  rowwise() \%>\%
  mutate(a2 = mean(a, a1))

## mutate
x1 \%>\%
  mutate(a1 = 5:7)

## transmute
x1 \%>\%
  transmute(a1 = 5:7)

## select
x1 \%>\%
  select(-time) \%>\%
  select(geometry)

## rename
x1 \%>\%
  rename(a1 = a)

## slice
x1 \%>\%
  slice(1:2)

## summarise
x1 \%>\%
  summarise(time = mean(time))
  
x1 \%>\%
  summarize(time = mean(time))

## distinct
x1 \%>\%
  distinct(geometry)

## gather
library(tidyr)
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  gather(key = "variable", value = "value", a, a1)

## pivot_longer
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  pivot_longer(cols = c("a", "a1"), names_to = "variable", values_to = "value")

## spread
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  gather(key = "variable", value = "value", a, a1) \%>\%
  spread(key = "variable", value = "value")

## sample_n
set.seed(234)
x1 \%>\%
  sample_n(size = 10, replace = TRUE)

## sample_frac
x1 \%>\%
  sample_frac(size = 10, replace = TRUE) \%>\%
  sample_frac(size = 0.1, replace = FALSE)

## nest
x1 \%>\%
  nest(a1 = -time)

## unnest
x1 \%>\%
  mutate(a1 = list(1, c(1, 2), 5)) \%>\%
  unnest(a1)

## separate
x1 \%>\%
  mutate(x = c(NA, "a.b", "a.d")) \%>\%
  separate(x, c("A", "B"))

## unite
x1 \%>\%
  mutate(x = c(NA, "a.b", "a.d")) \%>\%
  separate(x, c("A", "B")) \%>\%
  unite(x, c("A", "B"))
  
## separate_rows
x1 \%>\%
  mutate(z = c("1", "2,3,4", "5,6")) \%>\%
  separate_rows(z, convert = TRUE)

}
