% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-reactive-objects.R
\name{load_reactive_objects}
\alias{load_reactive_objects}
\title{Load inputs and convert reactive functions from an R/Rmd script to your environment}
\usage{
load_reactive_objects(
  file,
  restart = FALSE,
  envir = NULL,
  clear_environment = FALSE,
  keep = NULL
)
}
\arguments{
\item{file}{Rmd to be evaluated and loaded into your environment}

\item{restart}{When \code{TRUE}, will restart the current R session. If you have R default to restore RData by default, you will need to use the \code{clear_environment} argument as well}

\item{envir}{the environment shinyobjects should the load the objects into.}

\item{clear_environment}{When \code{TRUE}, will remove objects not named in \code{...}}

\item{keep}{a regular expression of objects to keep when \code{clear_environment = TRUE}}
}
\description{
This function will run all assignments of your R or Rmd. file In the process, this function will encourage the creation of a dummy \code{input} list that will mimic user input and allow your code to run. Lastly, reactive objects are converted to functions so they can still be called as \code{df()} etc.
}
\section{Warning}{

This function has the ability to overwrite your objects in your environment. Make sure you understand how this function works before moving forward.
}

\examples{
if (interactive()) {
  system.file(package = "shinyobjects", "Rmd/test_dashboard.Rmd") \%>\%
    load_reactive_objects()

  system.file(package = "shinyobjects", "Rmd/test_dashboard_no_inputs.Rmd") \%>\%
    load_reactive_objects()

  system.file(package = "shinyobjects", "Rmd/test_dashboard_missing_inputs.Rmd") \%>\%
    load_reactive_objects()
}
}
