% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscountCode.R
\name{DiscountCode}
\alias{DiscountCode}
\alias{createDiscountCode}
\alias{modifyDiscountCode}
\alias{getDiscountCodes}
\alias{getDiscountCode}
\alias{getDiscountCodeLocation}
\alias{deleteDiscountCode}
\alias{createDiscountCodesCreationJob}
\alias{getDiscountCodesCreationJob}
\alias{getDiscountCodesFromCreationJob}
\title{DiscountCode Functions}
\usage{
createDiscountCode(priceRuleId, code, ...)

modifyDiscountCode(priceRuleId, discountCode, ...)

getDiscountCodes(priceRuleId, ...)

getDiscountCode(priceRuleId, discountCodeId, ...)

getDiscountCodeLocation(code, ...)

deleteDiscountCode(priceRuleId, discountCodeId, ...)

createDiscountCodesCreationJob(priceRuleId, codes, ...)

getDiscountCodesCreationJob(priceRuleId, batchId, ...)

getDiscountCodesFromCreationJob(priceRuleId, batchId, ...)
}
\arguments{
\item{priceRuleId}{a \code{\link{PriceRule}} id}

\item{code}{one discount code string}

\item{...}{additional request parameters}

\item{discountCode}{a list containing DiscountCode fields}

\item{discountCodeId}{a DiscountCode id number}

\item{codes}{one or more discount code strings}

\item{batchId}{an id of a DiscountCode batch job}
}
\value{
a list containing a DiscountCode fields or a list of DiscountCodes
}
\description{
DiscountCode Functions
}
\references{
Shopify API DiscountCode documentation: \url{https://help.shopify.com/api/reference/discounts/discountcode}
}
