% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_siconv.R
\name{get_siconv}
\alias{get_siconv}
\title{Fetch cleaned data from Plataforma +Brasil}
\usage{
get_siconv(dataset = NULL, encoding = "UTF-8", cache = TRUE, verbose = TRUE)
}
\arguments{
\item{dataset}{A \code{string} indicating the dataset to retrieve. Valid options:
\itemize{
\item "programas" -- data on available programs maintained by the Federal Government;
\item "programas_propostas" -- keys to match programs and proposals submitted to the Federal Government;
\item "propostas" -- data on proposals submitted to the Federal Government;
\item "convenios" -- data on proposals effectively accepted situation and amount transferred by the Federal Government;
\item "emendas" -- data on federal budget amendments made by Brazilian Federal Deputies and Senators, amount transferred and the transference recipient;
\item "planos" -- data on application plans submitted to the Federal Government. This document includes all goods, services and works required
by the covenant to accomplish the project;
\item "empenhos" -- data on transfers which the Federal Government has reserved its budget to pay the covenant when the project ends;
\item "desembolsos" -- data on transfers disbursements by the Federal Government;
\item "obtv" -- data on payments made to local suppliers and contractors hired to execute funded projects;
\item "historico" -- proposals' track record;
\item "ingresso_contrapartida" -- record of counterpart payments;
\item "aditivos" -- data on contracts' budget addendum;
\item "crono_metas" -- project's goals timeline;
\item "cronogramas" -- project's execution timeline;
\item "consorcios" -- data on proposals where multiple local governments or private entities cooperate to request federal resources;
\item "empenhos_desembolsos" -- keys to match appropriations and disbursements by Federal Government;
\item "proponentes" -- data on proposals' proponents;
\item "cronograma_desembolsos" -- project's transfers disbursements timeline;
\item "justificativas" -- proposals' justifications;
}

When not specified, \code{dataset} defaults to "programas".}

\item{encoding}{Encoding used to read raw files. Defaults to "UTF-8", but users
might need to change this option to other valid options (e.g., "latin1") if
data are returned with uncommon characters.}

\item{cache}{Should the function maintain a local copy of the data? To save
both time and SICONV's server resources, this defaults to \code{TRUE}. Data is
stored as a zipfile in the foleer "cache" in the working directory (avoid
changing files' names inside this folder).}

\item{verbose}{Should the function display messages and progress bar? Defaults
to \code{TRUE}.}
}
\value{
A \link[tibble]{tibble} contantaining the requested data as defined in the
\code{dataset} argument. Use the \code{\link{show_schema}} function to get detailed information
on available variables and information.
}
\description{
\code{get_siconv()} is the package's workhorse. It downloads, cleans, and
returns one of the several datasets maintained by Plataforma +Brasil on federal
targeted transfers in Brazil. Under the hoods, the function handles GET requests,
downloads and stores intermediary files, and reads as fast as possible the data
to a \code{tibble} format convenient for use in analysis.
}
\note{
\code{get_siconv()} needs an internet connection to download data in case it
does not found a cache folder with raw data from a previous request. Be aware that instability
in the Plataforma +Brasil server might produce error messagens, in which case users
should try waiting before rerunning their requests.
}
\examples{
\dontrun{df <- get_siconv(dataset = "propostas")}
}
