% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate.simpr_spec}
\alias{generate.simpr_spec}
\title{Generate simulated data from specification}
\usage{
\method{generate}{simpr_spec}(
  x,
  .reps,
  ...,
  .sim_name = "sim",
  .quiet = TRUE,
  .warn_on_error = TRUE,
  .stop_on_error = FALSE,
  .debug = FALSE,
  .progress = FALSE,
  .options = furrr_options(seed = TRUE)
)
}
\arguments{
\item{x}{a \code{simpr_spec} object generated
by \code{\link{define}} or
\code{\link[=specify.formula]{specify}},
containing the specifications of the
simulation}

\item{.reps}{number of replications to run (a
whole number greater than 0)}

\item{\dots}{filtering criteria for which rows
to simulate, passed to
\code{\link[dplyr]{filter}}.  This is useful
for reproducing just a few selected rows of a
simulation without needing to redo the entire
simulation, see \code{vignette("Reproducing
simulations")},}

\item{.sim_name}{name of the list-column to be
created, containing simulation results.
Default is \code{"sim"}}

\item{.quiet}{Should simulation errors be
broadcast to the user as they occur?}

\item{.warn_on_error}{Should there be a warning
when simulation errors occur? See
\code{vignette("Managing simulation
errors")}.}

\item{.stop_on_error}{Should the simulation
stop immediately when simulation errors
occur?}

\item{.debug}{Run simulation in debug mode,
allowing objects, etc. to be explored for
each generated variable specification.}

\item{.progress}{A logical, for whether or not
to print a progress bar for multiprocess,
multisession, and multicore plans.}

\item{.options}{The \code{future} specific
options to use with the workers when using
futures. This must be the result from a call
to
\code{\link[furrr:furrr_options]{furrr_options(seed
 = TRUE)}}.}
}
\value{
a \code{\link{simpr_sims}} object,
  which is a tibble with a row for each
  repetition (a total of \code{rep}
  repetitions) for each combination of
  metaparameters and some extra metadata used
  by \code{\link[=fit.simpr_tibble]{fit}}.  The
  columns are \code{rep} for the repetition
  number, the names of the metaparameters, and
  a list-column (named by the argument
  \code{sim_name}) containing the dataset for
  each repetition and metaparameter
  combination. \code{simpr_sims} objects can be
  manipulated elementwise by \code{dplyr} and
  \code{tidyr} verbs: the command is applied to
  each element of the simulation list-column.
}
\description{
Use specification from
\code{\link[=specify.formula]{specify}} or
\code{\link{define}} to produce simulated data.
}
\details{
This is the third step in the simulation
process: after specifying the population model
and defining the metaparameters, if any,
\code{generate} is the workhorse function that
actually generates the simulated datasets, one
for each replication and combination of
metaparameters. You likely want to use the
output of \code{generate} to fit model(s) with
\code{\link[=fit.simpr_tibble]{fit}}.

Errors you get using this function usually have
to do with how you specified the simulation in
\code{\link[=specify.formula]{specify}} and
\code{\link{define}}.
}
\examples{
meta_list_out = specify(a = ~ MASS::mvrnorm(n, rep(0, 2), Sigma = S)) \%>\%
  define(n = c(10, 20, 30),
       S = list(independent = diag(2), correlated = diag(2) + 2)) \%>\%
  generate(3)

 ## View overall structure of the result and a single simulation output
 meta_list_out

 ## Changing .reps will change the number of replications and thus the number of
 ## rows in the output
 meta_list_2 = specify(a = ~ MASS::mvrnorm(n, rep(0, 2), Sigma = S)) \%>\%
  define(n = c(10, 20, 30),
       S = list(independent = diag(2), correlated = diag(2) + 2)) \%>\%
  generate(4)

 meta_list_2

 ## Fitting, tidying functions can be included in this step by running those functions and then
 ## generate.  This can save computation time when doing large
 ## simulations, especially with parallel processing
 meta_list_generate_after = specify(a = ~ MASS::mvrnorm(n, rep(0, 2), Sigma = S)) \%>\%
  define(n = c(10, 20, 30),
       S = list(independent = diag(2), correlated = diag(2) + 2)) \%>\%
  fit(lm = ~ lm(a_2 ~ a_1, data = .)) \%>\%
  tidy_fits \%>\%
  generate(4)

  meta_list_generate_after
}
\seealso{
\code{\link[=specify.formula]{specify}} and
  \code{\link{define}} for examples of how
  these functions affect the output of
  \code{generate}. See
  \code{vignette("Optimization")} and the
  \code{furrr} website for more information on
  working with futures:
  \url{https://furrr.futureverse.org/}
}
