% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_clustering_highD.R
\name{kmeans_haystack_highD}
\alias{kmeans_haystack_highD}
\title{Function for k-means clustering of genes according to their distribution in a higher-dimensional space.}
\usage{
kmeans_haystack_highD(
  x,
  detection,
  genes,
  grid.coordinates = NULL,
  k,
  scale = TRUE,
  ...
)
}
\arguments{
\item{x}{Coordinates of cells in a 2D or higher-dimensional space. Rows represent cells, columns the dimensions of the space.}

\item{detection}{A logical matrix showing which genes (rows) are detected in which cells (columns)}

\item{genes}{A set of genes (of the 'detection' data) which will be clustered.}

\item{grid.coordinates}{Coordinates of grid points in the same space as 'x', to be used to estimate densities for clustering.}

\item{k}{The number of clusters to return.}

\item{scale}{whether to scale data.}

\item{...}{Additional parameters which will be passed on to the kmeans function.}
}
\value{
An object of class kmeans, describing a clustering into 'k' clusters
}
\description{
Function for k-means clustering of genes according to their distribution in a higher-dimensional space.
}
\examples{
# to be added
}
