% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horizon.R
\name{hor2alt}
\alias{hor2alt}
\title{Retrieves horizon altitude for a given azimuth from a given horizon profile}
\usage{
hor2alt(hor, az, return.unc = F)
}
\arguments{
\item{hor}{A \emph{skyscapeR.horizon} object from which to retrieve horizon altitude.}

\item{az}{Array of azimuth(s) for which to retrieve horizon altitude(s).}

\item{return.unc}{(Optional) Boolean switch control where to output altitude uncertainty.
Default is \emph{FALSE}.}
}
\description{
This function retrieves the horizon altitude for a given azimuth from
a previously created \emph{skyscapeR.horizon} object via spline interpolation.
}
\examples{
hor <- downloadHWT('HIFVTBGK')
hor2alt(hor, 90)
}
\seealso{
\code{\link{createHor}}, \code{\link{downloadHWT}}
}
