% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_weights.R
\name{optimize_weights}
\alias{optimize_weights}
\title{Optimize weights from list of prediction matrices}
\usage{
optimize_weights(predictionlist, outcome, FUN = trps)
}
\arguments{
\item{predictionlist}{A list of R x T prediction matrices where each column sum to 1 and each row sums to}

\item{outcome}{An integer vector listing the}

\item{FUN}{The function used for optimizing the predictions. The default is top use rps for the rank probability score. Another option is logloss for log loss.}
}
\value{
Returns a numeric vector containing an optimal vector of weights that sum to 1 and that minimizes the loss function.
}
\description{
Computes the optimal weights to obtain the minimal loss function from a list of prediction matrices.
}
\examples{

m1 <- matrix(c(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, .5, .5, 0, 0, .5, .5), 4)
m1 # Prediction where certain on the top ranks
m2 <- matrix(c(.5, .5, 0, 0, .5, .5, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1), 4)
m2  # Prediction where the groups are okay 
m3 <- matrix(c(.5, .5, 0, 0, .5, .5, 0, 0, 0, 0, .5, .5, 0, 0, .5, .5), 4)
m3  # Prediction where no clue about anything
m4 <- matrix(rep(1/4, 16), 4)

optimize_weights(list(m1, m2, m3, m4), 1:4)

}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk}
}
\keyword{manip}
