% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{SpeedOfSoundSeaWaterChenAndMillero}
\alias{SpeedOfSoundSeaWaterChenAndMillero}
\title{speed of sound (m/s) in sea water from Chen and Millero 1977}
\source{
C-T. Chen and F.J. Millero, 1977
Underwater Acoustics Technical Guides - Speed of Sound in Sea Water
\url{http://resource.npl.co.uk/acoustics/techguides/soundseawater/}
}
\usage{
SpeedOfSoundSeaWaterChenAndMillero(S, temperatureC, P)
}
\arguments{
\item{S,}{salinity in parts per thousand}

\item{temperatureC,}{temperature in degrees Celsius}

\item{P,}{pressure in kg/cm^2}
}
\value{
the speed of sound (m/s)
}
\description{
Returns the speed of sound (m/s)
 Range of validity: temperature 0 to 40 C, salinity 0 to 40 parts per thousand, pressure
 0 to 1000 bar
}
\examples{
SpeedOfSoundSeaWaterChenAndMillero(30, 0, 1.019716)
}
\author{
Jose Gama
}
\references{
C-T. Chen and F.J. Millero, 1977
Speed of sound in seawater at high pressures
J. Acoust. Soc. Am. 62(5) pp 1129-1135
}

