% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection_cv_tnkde_sf.R
\name{bw_checks}
\alias{bw_checks}
\title{Check function for parameters in bandwidth selection methods}
\usage{
bw_checks(
  check,
  lines,
  samples,
  events,
  kernel_name,
  method,
  bw_net_range = NULL,
  bw_time_range = NULL,
  bw_net_step = NULL,
  bw_time_step = NULL,
  diggle_correction = FALSE,
  study_area = NULL
)
}
\arguments{
\item{check}{A boolean indicating if the geometries must be checked}

\item{lines}{A feature collection of linestrings representing the underlying network}

\item{samples}{A feature collection of points representing the sample location}

\item{events}{a feature collection of points representing the events}

\item{kernel_name}{The name of the kernel to use}

\item{method}{The name of the NKDE to use}

\item{bw_net_range}{The range for the network bandwidth to consider, given as a numeric
vector of two values: c(bandwidth_min, bandwidth_max)}

\item{bw_time_range}{The range for the time bandwidth to consider, given as a numeric
vector of two values: c(bandwidth_min, bandwidth_max)}

\item{bw_net_step}{The step between each network bandwidth to calculate, given as a float}

\item{bw_time_step}{The step between each time bandwidth to calculate, given as a float}

\item{diggle_correction}{A Boolean indicating if the correction factor
for edge effect must be used.}

\item{study_area}{A feature collection of polygons 
representing the limits of the study area.}
}
\description{
A check function for bandwidth selection methods raising an error if a parameter is not valid
}
\examples{
# no example provided, this is an internal function
}
\keyword{internal}
