% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{Matrix.to.Coord}
\alias{Matrix.to.Coord}
\title{Row and column indices from sparse matrix.}
\usage{
Matrix.to.Coord(M, index1 = TRUE)
}
\arguments{
\item{M}{A matrix that is a subclass of sparseMatrix, as defined in
the Matrix package.}

\item{index1}{TRUE if the index of the first element should be 1,
and FALSE if 0.}
}
\value{
A list with two named elements.
\describe{
\item{rows}{Integer vector containing row indices of non-zero elements}
\item{cols}{Integer vector containing column indices of non-zero elements}
}
}
\description{
Utility function to extract row and column indices of
the non-zero
elements of a sparse matrix.
}
\details{
A wrapper to \link{Matrix.to.Pointers} for \code{order='triplet'}
and \code{values=FALSE}, for extracting the row and column indices
of a sparsity pattern from a matrix that has that same pattern.
}
\examples{
M1 <- as(kronecker(diag(3), matrix(TRUE,2,2)),"sparseMatrix")
C <- Matrix.to.Coord(M1)
M2 <- Matrix::sparseMatrix(i=C$rows, j=C$cols)
all.equal(M1,M2)
}
