% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spnormw}
\alias{spnormw}
\title{Normalizes the Absorbance of a Matrix of Mid-infrared Spectra by a Specific Band}
\usage{
spnormw(spectra, wn)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{wn}{numeric. Specific band (wavenumber) used to normalize the spectra.}
}
\value{
A matrix spectra normalized by a specific band. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.
}
\description{
The absorbance values of the matrix of mid-infrared spectra is normalized by a specific band.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# Normalized spectra by a specific band
normw <- spnormw(spectra=spectra, wn=1510)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

