% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{sppeak}
\alias{sppeak}
\title{Identification of Peaks of a Mid-infrared Spectra}
\usage{
sppeak(spectra, span = 3, tol = 0.2)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{span}{numeric. Peak detection threshold.}

\item{tol}{numeric. Percentage of the maximum value of the spectrum (positive value).}
}
\value{
An object of class sppeak, which is a list of matrices for each of the spectrum.
}
\description{
This function allows to identify peaks of a mid-infrared spectra.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# List of peak detection
pks <- sppeak(spectra=spectra, span=3, tol=0.2)
# Peaks of the first spectrum
pks[[1]]
# Peaks of the second spectrum
pks[[2]]
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

