% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute.R
\name{execute_lua}
\alias{execute_lua}
\title{Execute a custom rendering script and return a result.}
\usage{
execute_lua(splash_obj, lua_source, timeout = 30, allowed_domains, proxy,
  filters, save_args, load_args)
}
\arguments{
\item{splash_obj}{Object created by a call to \code{\link[=splash]{splash()}}}

\item{lua_source}{Browser automation script. See \href{http://splash.readthedocs.io/en/stable/scripting-tutorial.html#scripting-tutorial}{Splash Script} Tutorial for more info.}

\item{timeout}{A timeout (in seconds) for the render (defaults to 30). Without
reconfiguring the startup parameters of the Splash server (not this package)
the maximum allowed value for the timeout is 60 seconds.}

\item{allowed_domains}{Comma-separated list of allowed domain names. If present, Splash
won’t load anything neither from domains not in this list nor from subdomains of
domains not in this list.}

\item{proxy}{Proxy profile name or proxy URL.}

\item{filters}{Comma-separated list of request filter names.}

\item{save_args}{A list of argument names to put in cache.}

\item{load_args}{Parameter values to load from cache}
}
\value{
\code{raw} content from the \code{httr} call. Given the vast diversity of possible return
values, it's up to the caller to handle the return value.
}
\description{
Execute a custom rendering script and return a result.
}
\examples{
\dontrun{
splash_local \%>\%
  execute_lua('
function main(splash)
  splash:go("https://projects.fivethirtyeight.com/congress-trump-score/")
  splash:wait(0.5)
  return splash:evaljs("memberScores")
end
') -> res

rawToChar(res) \%>\%
  jsonlite::fromJSON(flatten=TRUE) \%>\%
  purrr::map(tibble::as_tibble) -> member_scores

member_scores
}
}
\seealso{
Other splash_renderers: \code{\link{render_har}},
  \code{\link{render_html}}, \code{\link{render_jpeg}},
  \code{\link{render_json}}, \code{\link{render_png}}
}
\concept{splash_renderers}
