% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splineTree.R
\name{getBasisMat}
\alias{getBasisMat}
\title{Get the basis matrix to be used for this spline tree}
\usage{
getBasisMat(yvar, tvar, idvar, data, knots = NULL, df, degree, intercept,
  gridPoints, nGrid = 7)
}
\arguments{
\item{yvar}{Name of response variable (string)}

\item{tvar}{Name of time variable (string)}

\item{idvar}{Name of ID variable (string)}

\item{data}{Full dataset}

\item{knots}{Knots argument specified by user. Specifies location of INTERNAL knots.}

\item{df}{Degrees of freedom argument specified by user}

\item{degree}{The degree of the spline polynomial}

\item{intercept}{Whether or not to use an intercept}

\item{gridPoints}{Optional. A vector of numbers that will be used as the grid on which to evaluate the
projection sum of squares. Should fall roughly within the range of the time variable.}

\item{nGrid}{Number of grid points to evaluate split function at.}
}
\value{
The basis matrix to be used for the tree building process
}
\description{
Using the user-specified parameters or the default parameters, computes the basis matrix that will be used for building the tree.
}
\keyword{internal}
