% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.slmfit.R
\name{coef.slmfit}
\alias{coef.slmfit}
\title{Extract Model Coefficients from a \code{\link{slmfit}} object}
\usage{
\method{coef}{slmfit}(object, ...)
}
\arguments{
\item{object}{a \code{\link{slmfit}} object}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a vector of fitted model coefficients.
}
\description{
Extract Model Coefficients from a \code{\link{slmfit}} object
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
coef(slmobj)
}
