% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_vcf.R
\name{summary_vcf}
\alias{summary_vcf}
\title{VCF Data Summary}
\usage{
summary_vcf(vcf, ZG = NULL, CHR = NULL)
}
\arguments{
\item{vcf}{VCF object from read_vcf function}

\item{ZG}{zygosity: (1) null, for both het and hom, default; (2) het; (3) hom}

\item{CHR}{chromosome number: (1) null, all chromosome, default; (2) any specific number}
}
\value{
A list containing (1) scatter: allele frequency scatter plot; (2) density: allele frequency density plot
}
\description{
Summarizes allele frequency information in scatter and density plots
}
\examples{
data("vcf_example")
tmp <- summary_vcf(vcf = vcf_example, ZG = 'het', CHR = c(1,2))
plot(tmp$scatter)
plot(tmp$density)
}
