% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health-base.R
\name{health}
\alias{health}
\title{Constructing a Health Delta-Normal Term with Respect to healthRisk}
\usage{
health(name, currency, sensitivity)
}
\arguments{
\item{name}{character value. the names of the health risk factors.
Note that no duplicated names should appear.}

\item{currency}{character value. The currencies in which
\code{sensitivity} are expressed.}

\item{sensitivity}{positive numeric value. The sensitivities with respect
for the corresponding risk-factors. Sensitivities must be
expressed in the corresponding currency in the column \code{currency}.
Nevertheless, it is forced at construction of
a \code{portfolio} that the sensitivities should be provided in the \code{portfolio} base
currency. Please note that the sensitivities are understood as volatilities for the
the corresponding risks, we thus force the sensitivities to
be strictly positive.}
}
\value{
An S3 object, instance of the class health.
}
\description{
\code{health} is the constructor for the S3 class health.
  It allows to build for the sensitivities (understood as volatilities)
  for health insurance risks.
}
\note{
All parameters must be of equal length.
}
\examples{
# Creating a new health.
health1 <- health(name        = c("pandemy", "longetivity", "storno"),
                  currency    = c("EUR", "CHF", "EUR"),
                  sensitivity = c(100, 150, 130))

}
\seealso{
\code{\link{summary.health}}, \code{\link{print.health}}.
}
