% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp.r
\name{stamp}
\alias{stamp}
\title{Spatial temporal analysis of moving polygons}
\usage{
stamp(T1, T2, dc = 0, direction = FALSE, distance = FALSE, ...)
}
\arguments{
\item{T1}{a \code{SpatialPolygonsDataFrame} object of polygons from time 1.}

\item{T2}{a \code{SpatialPolygonsDataFrame} object of polygons from time 2.}

\item{dc}{spatial distance threshold for determining groupings (see \bold{Details}) in appropriate units.}

\item{direction}{logical, whether or not to perform directional analysis. See documentation for
\code{stamp.direction} for further details.}

\item{distance}{logical, whether or not to perform distance analysis. See documentation for 
\code{stamp.distance} for further details.}

\item{...}{additional parameters to be passed to functions if \code{direction}, or \code{distance} are
set to \code{TRUE}.}
}
\value{
This function returns a \code{SpatialPolygonsDataFrame} with the following data columns:
 \item{ID1}{Polygon ID from T1 polygons; \code{NA} if it did not exist,}
 \item{ID2}{Polygon ID from T2 polygons; \code{NA} if it did not exist,}
 \item{LEV1}{Level 1 STAMP designation,}
 \item{LEV2}{Level 2 STAMP designation,}
 \item{LEV3}{Level 3 STAMP designation,}
 \item{LEV4}{Level 4 STAMP designation,}
 \item{GROUP}{Group ID signifying group membership,}
 \item{AREA}{Polygon area in appropriate areal units,}
 \item{--}{(optional) Additional columns from directional analysis if \code{direction = TRUE},}
 \item{--}{(optional) Additional columns from distance analysis if \code{distance = TRUE},}
}
\description{
This function generates a \code{SpatialPolygonsDataFrame} that can be used for spatial temporal analysis of moving polygons
as described in the paper Robertson et al. (2007).
}
\details{
The \code{stamp} function can be used to perform spatial temporal analysis of moving polygons (STAMP)
 as outlined in the paper by Robertson et al., (2007). Polygon movement "groups" are delineated based on
 polygon connectedness defined by the distance threshold \code{dc}. That is, if polygon
 boundaries (in T1 or T2) are within distance \code{dc} of one another they will be designated
 to the same group. STAMP events are reported at four levels of increasing complexity: \cr
 LEV1 -- disappearance (\code{DISA}), stable (\code{STBL}), and generation (\code{GENA}); \cr
 LEV2 -- disappearance (\code{DISA}), contraction (\code{CONT}), stable (\code{STBL}),
         expansion (\code{EXPN}), and generation (\code{GENR}); \cr
 LEV3 -- disappearance (\code{DISA}), T1 displacement (\code{DISP1}), convergence (\code{CONV}),
         concentration (\code{CONC}), contraction (\code{CONT}), stable (\code{STBL}),
         expansion (\code{EXP}), fragmentation (\code{FRAG}), divergence (\code{DIV}),
         T2 displacement (\code{DISP2}), and generation (\code{GENR}); \cr
 LEV4 -- LEV4 is different from other levels. It is used to identify those groups where
         union (\code{UNION}), division (\code{DIVISION}), and both union and division
         (\code{BOTH}) events occur. These events occur when there are more than one
         stable event in a group. Groups with one or no stable events recieve an \code{NA}
         value for LEV4. \cr
 See Robertson et al. (2007; especially Figure 1) for complete descriptions of all STAMP movement
 event types.
 
 Note also that there must be a globally unique \code{ID} column in each data frame passed to the stamp function
}
\references{
Robertson, C., Nelson, T., Boots, B., and Wulder, M. (2007) STAMP: Spatial-temporal analysis of moving polygons.
 \emph{Journal of Geographical Systems}, 9:207-227.
}
\seealso{
stamp.direction stamp.distance stamp.shape stamp.map stamp.group.summary
}
\keyword{stamp}
