#' Bread-making problem data
#'
#' Data from a bread-making mixture experiment, to
#' investigate and to value the final quality of flour.
#'
#' @docType data
#'
#' @usage data(bread_mixture)
#'
#' @format A data frame containing 90 rows and 6 variables.
#'
#' The  response  variable  was considered as the loaf volume after baking with target value of 530 ml.
#'
#' Control  variables:
#'
#' \itemize{
#' \item \eqn{x_1}: Tjalve
#' \item \eqn{x_2}: Folke
#' \item \eqn{x_3}: HardRed  Spring
#' }
#'
#' Process  variables:
#'
#'\itemize{
#' \item \eqn{z_1}:  mixing  time
#' \item \eqn{z_2}: proofing  (resting)  time  of the  dough
#' }
#'
#' @details
#' The bread-making problem, originally presented by Faergestad
#' and Naes (1997),  according  to  Naes  et  al. (1998),
#' consisted  of  an  experiment  with three ingredients of
#' mixture and two noise variables,  and had as objective to
#' investigate and to value the final quality of flour, composed
#' by different mixtures of wheat flour, for production of bread.
#'
#' @references Faergestad,  E. M.,  Naes,  T. (1997). Evaluation of baking quality
#' of wheat flours: I: small scale straight dough baking test of heart bread with
#' variable mixing time and proofing time. In:  \emph{Report MATFORSK}, As, Norway.
#'
#' @references Naes, T., Faergestad, E. M., Cornell, J. A. (1998).
#' A comparison of methods for  analyzing  data  from  a
#'  three  component  mixture  experiment  in  the presence
#'  of variation created by two process variables, \emph{Chemometrics
#'   and Intelligence Laboratory Systems}, v. 41, pp. 221-235.
#'
#'
#' @examples
#' data(bread_mixture)
#' head(bread_mixture)
"bread_mixture"
