% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{data_stopwords_ancient}
\alias{data_stopwords_ancient}
\title{stopword lists for ancient languages}
\format{
An object of class \code{list} of length 2.
}
\source{
Aurélien Berra, Ancient Greek and Latin stopwords,
\doi{10.5281/zenodo.1165205}. See
\url{https://github.com/aurelberra/stopwords/blob/master/rationale.md}.
}
\description{
Stopword lists for ancient Greek and Latin.  These lists are far more
extensive than the \link[=data_stopwords_perseus]{Perseus lists} for ancient Greek
and Latin from the Perseus Digital Library.
}
\details{
As there is no 2-letter code for ancient Greek in ISO-639-1, we use "grc" to
denote Greek (as per \href{https://iso639-3.sil.org/code/grc}{ISO-639-3}).
}
\section{Usage}{

\code{stopwords(language = "grc", source = "ancient")}

\code{stopwords(language = "la", source = "ancient")}
}

\seealso{
\link{data_stopwords_perseus}
}
\keyword{datasets}
