% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.optim.R
\name{data.optim}
\alias{data.optim}
\title{To implement the Dynamic Programming (DP) solution procedure on the stratification
problem presented in the form of a Mathematical Programming Problem (MPP)}
\usage{
data.optim(k, n, incf, minYk, maxYk, isFirstRun = TRUE, my_env)
}
\arguments{
\item{k}{A numeric: number of strata}

\item{n}{A numeric: is the distance*1000}

\item{incf}{A numeric: 10e-3 when k=1 and 10e-5 for k>=2}

\item{minYk}{A numeric: index to access minimum elements in the matrix}

\item{maxYk}{A numeric: index to access maximum elements in the matrix}

\item{isFirstRun}{A boolean: TRUE/FALSE parameter}

\item{my_env}{The environment my_env has various constants and calculations stored
from earlier opeartions through various other functions}
}
\value{
\code{} returns the array filled with calculations of objective
function values
}
\description{
This function uses the Dynamic Programming (DP) solution procedure in solving the
objective function for the univariate stratification problem. It calculates
the objective function values using the brute-force algorithm and stores those
values in the matrices and keeps a copy in my_env so that a global minimum
could be obtained.
}
\author{
Karuna Reddy <karuna.reddy@usp.ac.fj>\cr M
GM Khan <khan_mg@usp.ac.fj>
}
