% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AWKMT2.R
\docType{package}
\name{survAWKMT2-package}
\alias{survAWKMT2-package}
\title{Two-Sample Tests Based on Weighted Differences of Kaplan-Meier Curves}
\description{
Tests for equality of two survival functions based on integrated weighted differences of two Kaplan-Meier curves.
}
\examples{
D        = survival::pbc[1:312, c(2,3,4)] #The pbc data from 'survival' package
D$status = as.numeric(D$status==2)
D$trt    = as.numeric(D$trt==2)
names(D) = c("time", "status", "arm")
tau      = max(D[D[,2]==1,1])
nmethod  = 10 #Recommended to specify at least 10000 (default) or larger.

a = AWKMT2(indata=D, tau=tau, c_first=0, c_last=4, c_by=0.1, method="permutation",
           nmethod=nmethod, seed=1, v1=TRUE, v2=TRUE, test="1_side")
print(a)
}
\author{
Miki Horiguchi, Hajime Uno
}
\references{
Uno H, Tian L, Claggett B, Wei LJ. A versatile test for equality of two survival functions based on weighted differences of Kaplan-Meier curves.
Statistics in Medicine 2015, 34, 3680-3695.
}
\seealso{
survival
}

