% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst2adapt-ver001.R
\name{rmst2adapt}
\alias{rmst2adapt}
\title{Flexible and Coherent Test/Estimation Procedure Based on Restricted Mean Survival Times}
\usage{
rmst2adapt(indata, tau_star, method="perturbation", nmethod=100000,
        seed=NULL, test="2_side", conf.int=0.95)
}
\arguments{
\item{indata}{A data matrix (data frame). The 1st column is time-to-event variable, the 2nd column is event indicator (1=event, 0=censor), and the 3rd column is the treatment indicator (1=treatment, 0=control).
No missing values are allowed in this data matrix.}

\item{tau_star}{A vector indicating a set of tau's. All elements in \code{tau_star} need to be shorter than or equal to the minimum of the largest observed time on each of the two groups.}

\item{method}{A name of the resampling method. It supports \code{"perturbation"} (default) and \code{"permutation"}.}

\item{nmethod}{A number of iterations for the resampling. Recommended to specify at least 100000 (default) or larger.}

\item{seed}{An integer value, used for the random number generation in the resampling procedures. Default is \code{NULL}.}

\item{test}{Specify \code{"1_side"} for the one-sided test where the alternative hypothesis is that treatment group is superior to control group with respect to survival.
Specify \code{"2_side"} for the two-sided test where the alternative hypothesis is that treatment group is not equal to control group with respect to survival.
Default is \code{"2_side"}.}

\item{conf.int}{Specify confidence coefficient for confidence bands of the differences in RMST. Default is \code{0.95}.}
}
\value{
an object of class rmst2adapt.

\item{method}{The resampling method used in the analyses}

\item{nmethod}{The number of iterations for the resampling}

\item{test}{The type of test used in the analyses}

\item{candidate_taus}{The set of tau's used in the analyses}

\item{observed_z}{The observed test statistic Z_star}

\item{p_value}{The p-value of testing for equality}

\item{conf_band}{The difference in RMST between two groups at the specified tau's}

\item{selected_tau}{The value of tau selected to summarize the treatment effect}
}
\description{
Performs the procedure proposed by Horiguchi et al. (2018) <doi:10.1002/sim.7661>.
The method specifies a set of truncation time points tau's for calculating restricted mean survival times (RMST),
performs testing for equality, and estimates the difference in RMST between two groups at the specified tau's.
Multiplicity by specifying several tau's is taken into account in this procedure.
}
\examples{
#--- sample data ---#
data    = rmst2adapt.sample.data()
nmethod = 100 #This is only for example use.
              #Recommended to specify at least 100000 (default) or larger.

a = rmst2adapt(indata=data, tau_star=seq(6,12,2), method="perturbation",
               nmethod=nmethod, test="2_side")
print(a)
}
\references{
Horiguchi M, Cronin A, Takeuchi M, Uno H. A flexible and coherent test/estimation procedure based on restricted mean survival times for censored time-to-event data
in randomized clinical trials. Statistics in Medicine 2018. doi:10.1002/sim.7661.
}
\author{
Miki Horiguchi, Hajime Uno
}
